% Run simulations used in Katzin et al (2020) Biosystems Engineering:
%   Katzin, D., van Mourik, S., Kempkes, F., & van Henten, E. J. (2020). 
%   GreenLight  An open source model for greenhouses with supplemental lighting: 
%   Evaluation of heat requirements under LED and HPS lamps. 
%   Biosystems Engineering, 194, 6181. https://doi.org/10.1016/j.biosystemseng.2020.03.010
%
% This script file should be run from its directory, i.e., the active directory in
% MATLAB should be ...\Data from GreenLight (2020)\Simulation data\Source code

% David Katzin, Wageningen University & Research
% david.katzin@wur.nl
%
% Written in July 2023, reconstructing what was done for the paper back
% in 2019.
% Note: in order to precisely reproduce the results of the paper, this
% script must be run in MATLAB R2018b 
% (other versions may generate different results)

%% Climate model - LED
clear;
currentFilename = mfilename();
fullFilePath = mfilename('fullpath');
currentFileDir = strrep(fullFilePath, currentFilename, '');
if isempty(currentFileDir) || contains(currentFileDir, 'Temp\Editor') % This script is run from the console
    currentFileDir = cd(); % the directory from which this script is running
end
 
addpath(genpath([currentFileDir '\BramVanthoorModelVer2']));
addpath(genpath([currentFileDir '\StateSpaceModel']));
cd([currentFileDir '\BramVanthoorModelVer2\Code']);
climateModelEval_led_local;
cd(currentFileDir);

%% Climate model - HPS
clear;
currentFilename = mfilename();
fullFilePath = mfilename('fullpath');
currentFileDir = strrep(fullFilePath, currentFilename, '');
if isempty(currentFileDir) || contains(currentFileDir, 'Temp\Editor') % This script is run from the console
    currentFileDir = cd(); % the directory from which this script is running
end

addpath(genpath([currentFileDir '\BramVanthoorModelVer2']));
addpath(genpath([currentFileDir '\StateSpaceModel']));
cd([currentFileDir '\BramVanthoorModelVer2\Code']);
climateModelEval_hps_local;
cd(currentFileDir);

%% Energy use model - LED
clear;
currentFilename = mfilename();
fullFilePath = mfilename('fullpath');
currentFileDir = strrep(fullFilePath, currentFilename, '');
if isempty(currentFileDir) || contains(currentFileDir, 'Temp\Editor') % This script is run from the console
    currentFileDir = cd(); % the directory from which this script is running
end

addpath(genpath([currentFileDir '\BramVanthoorModelVer2']));
addpath(genpath([currentFileDir '\StateSpaceModel']));
cd([currentFileDir '\BramVanthoorModelVer2\Code']);
energyUseEval_led_local;
cd(currentFileDir);

%% Energy use model - HPS
clear;
currentFilename = mfilename();
fullFilePath = mfilename('fullpath');
currentFileDir = strrep(fullFilePath, currentFilename, '');
if isempty(currentFileDir) || contains(currentFileDir, 'Temp\Editor') % This script is run from the console
    currentFileDir = cd(); % the directory from which this script is running
end

addpath(genpath([currentFileDir '\BramVanthoorModelVer2']));
addpath(genpath([currentFileDir '\StateSpaceModel']));
cd([currentFileDir '\BramVanthoorModelVer2\Code']);
energyUseEval_hps_local;
cd(currentFileDir);

%% Move output files to the output directory
% Ensure currentFileDir ends with a  '\'
if currentFileDir(end) ~= '\'
    currentFileDir = [currentFileDir '\'];
end
currentDirSlashes = strfind(currentFileDir,'\');
simDir = currentFileDir(1:currentDirSlashes(end-1)); % Up one level from currentFileDir
                                                % This should be the
                                                % "Simualtion data\" directory
outputPath = [simDir 'MATLAB output\Replicated 2023'];
if ~exist(outputPath, 'dir')
    mkdir(outputPath)
end

movefile([currentFileDir '\BramVanthoorModelVer2\Code\*.mat'], ...
    outputPath);
